#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 normal;
out vec2 uv;

void main()
{
	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;

	vec4 pos = ModelViewProjectionMatrix * vec4(POSITION, 1.0);
#if 0
	const float quant = 16.0;
	pos.xy = floor(pos.xy*quant)/quant;
#endif

	gl_Position = pos;
}
